﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using MvcMovie.Models;

//dopisane
using System.IO;

namespace MvcMovie.Controllers
{ 
    //tu dodany własny filtr!!!!!!!!!!!!!!
    class LogAttribute : ActionFilterAttribute
    {
        //filtrowanie przed lub po akcji

        public override void OnActionExecuting(ActionExecutingContext filterContext)
        {
            base.OnActionExecuting(filterContext);

            string sciezkaDoPliku = filterContext.HttpContext.Server.MapPath("~/App_Data/log.txt");
            TextWriter tw = new StreamWriter(sciezkaDoPliku, true);
            tw.WriteLine("# Rozpoczęto wykonywanie akcji");
            tw.WriteLine("Data: "+DateTime.Now.ToString());
            tw.WriteLine("Kontroler: " + filterContext.ActionDescriptor.ControllerDescriptor.ControllerName);
            tw.WriteLine("Akcja: " + filterContext.ActionDescriptor.ActionName);

            if (filterContext.ActionParameters.Count > 0)
            {
                int i = 0;
                foreach (object parameter in filterContext.ActionParameters.Values)
                {
                    tw.WriteLine("Parametr " + i + " = " + parameter);
                    ++i;
                }
            }

            tw.Close();
        }

        public override void OnActionExecuted(ActionExecutedContext filterContext)
        {
            base.OnActionExecuted(filterContext);

            string sciezkaDoPliku = filterContext.HttpContext.Server.MapPath("~/App_Data/log.txt");
            TextWriter tw = new StreamWriter(sciezkaDoPliku, true);
            tw.WriteLine("# Zakonczono wykonywanie akcji");
            tw.WriteLine("Data: " + DateTime.Now.ToString());
            tw.WriteLine("Kontroler: " + filterContext.ActionDescriptor.ControllerDescriptor.ControllerName);
            tw.WriteLine("Akcja: " + filterContext.ActionDescriptor.ActionName);

            tw.WriteLine("Czy akcja anulowana: " + filterContext.Canceled);
            tw.WriteLine("Czy był wyjątek: " + filterContext.Exception);

            tw.Close();
        }
    };

    [Log] //tu dodany nasz atrybut (tak można dopiero od MVC3?)
    public class MoviesController : Controller
    {
        private MovieDBContext db = new MovieDBContext();

        //
        // GET: /Movies/

        public ViewResult Index()
        {
            return View(db.Movies.ToList());
        }

        //
        // GET: /Movies/Details/5

        //tu dopisane atrybuty !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        //[RequireHttps]        
        //[Authorize(Users="Jacek")] //można też Roles=
        //[NonAction] //nie ma dostepu
        //[HandleError] //nie trzeba tego pisać, bo jest globalnie zarejestrowany w Global.asax
        [HandleError(View="Wyjatek_ZlyIndeks",Order=2/*,ExceptionType=typeof(NullReferenceException)*/)]
        //parametr Order - kolejność wykonywania filtrów jeżeli wiele atrybutów zgromadzonych przed akcją
        public ViewResult Details(int id)
        {
            Movie movie = db.Movies.Find(id);
            return View(movie);
        }

        //
        // GET: /Movies/Create
        
        public ActionResult Create()
        {
            return View();
        }

        //tu dodane!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        public ActionResult PobierzLog()
        {
            string sciezkaDoPliku = Server.MapPath("~/App_Data/log.txt");
            return File(sciezkaDoPliku, "text/plain");
        }

        //
        // POST: /Movies/Create

        [HttpPost]
        public ActionResult Create(Movie movie)
        {
            if (ModelState.IsValid)
            {
                db.Movies.Add(movie);
                db.SaveChanges();
                return RedirectToAction("Index");  
            }

            return View(movie);
        }
        
        //
        // GET: /Movies/Edit/5
        public ActionResult Edit(int id)
        {
            Movie movie = db.Movies.Find(id);
            return View(movie);
        }

        //
        // POST: /Movies/Edit/5

        [HttpPost]
        public ActionResult Edit(Movie movie)
        {
            if (ModelState.IsValid)
            {
                db.Entry(movie).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(movie);
        }

        //
        // GET: /Movies/Delete/5
 
        public ActionResult Delete(int id)
        {
            Movie movie = db.Movies.Find(id);
            return View(movie);
        }

        //
        // POST: /Movies/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {            
            Movie movie = db.Movies.Find(id);
            db.Movies.Remove(movie);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}